// Autor: Gustav Matula

#include <cstdio>
#include <cstring>
#include <cstdlib>
#include <cassert>

#include <set>
#include <map>
#include <vector>
#include <algorithm>
#include <functional>
#include <queue>

#include <sstream>
#include <iostream>

using namespace std;
typedef long long llint;
const llint inf = 1000000000000000000LL;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)

#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

const int MAXN = 2005;
const int dx[] = {1, 0, -1, 0};
const int dy[] = {0, 1, 0, -1};

struct MinQ {
  deque<int> q, m;

  int min() { return m.front(); }
  void clear() { q.clear(); m.clear(); }

  void push(int x) {
    q.push_back(x);
    while (!m.empty() && x < m.back()) 
      m.pop_back();
    m.push_back(x);
  }

  void pop() {
    if (q.front() == m.front())
      m.pop_front();
    q.pop_front();
  }
};

void calc_row(int *a, int n, int c) {
  MinQ mq;
  REP(i, min(n, c)) mq.push(a[i]);
  REP(i, n) {
    a[i] = mq.min();
    if (i + c < n) mq.push(a[i + c]);
    mq.pop();
  }
}

void calc(int a[MAXN][MAXN], int n, int r, int c) {
  REP(i, n) calc_row(a[i], n, c);
  REP(i, n) REP(j, i) swap(a[i][j], a[j][i]);
  REP(i, n) calc_row(a[i], n, r);
  REP(i, n) REP(j, i) swap(a[i][j], a[j][i]);
}

void bfs01(char m[MAXN][MAXN], int a[MAXN][MAXN], int n, int x, int y) {
  memset(a, 0x3f, 4 * MAXN * MAXN);
  deque<pair<int,int>> q;
  q.push_back({x, y});
  a[x][y] = m[x][y] - '0';
  assert(a[x][y] == 0);

  while (!q.empty()) {
    int x, y;
    tie(x, y) = q.front(); q.pop_front();

    REP(d, 4) {
      int nx = x + dx[d];
      int ny = y + dy[d];
      if (nx < 0 || nx >= n) continue;
      if (ny < 0 || ny >= n) continue;
      if (a[x][y] + m[nx][ny] - '0' < a[nx][ny]) {
	a[nx][ny] = a[x][y] + m[nx][ny] - '0';
	if (m[nx][ny] == '0')
	  q.push_front({nx, ny});
	else
	  q.push_back({nx, ny});
      }
    }
  }
}

void fix(int a[MAXN][MAXN], int n) {
  static int tmp[MAXN][MAXN];
  REP(i, n) REP(j, n) {
    tmp[i][j] = a[i][j];
    REP(d, 4) {
      int nx = i + dx[d];
      int ny = j + dy[d];
      if (nx < 0 || nx >= n) continue;
      if (ny < 0 || ny >= n) continue;
      tmp[i][j] = min(tmp[i][j], a[nx][ny]);
    }
  }
  REP(i, n) REP(j, n)
    a[i][j] = tmp[i][j];
}

int solve(char m[MAXN][MAXN], int n, int k, int l, int xa, int ya, int xb, int yb) {
  static int a[MAXN][MAXN];
  static int b[MAXN][MAXN];

  bfs01(m, a, n, xa, ya);
  bfs01(m, b, n, xb, yb);

  calc(a, n, k, l);
  calc(b, n, k, l);
  fix(a, n);
  fix(b, n);

  int sol = 1e9;
  int cnt = 0;
  REP(i, n) REP(j, n) {
    if (sol > a[i][j] + b[i][j]) {
      sol = a[i][j] + b[i][j];
      cnt = 0;
    }
    if (sol == a[i][j] + b[i][j])
      ++cnt;
  }

  return sol;
}

int main(void) 
{
  static char m[MAXN][MAXN];
  int n, k;
  scanf("%d", &n);
  REP(i, n) scanf("%s", m[i]);

  int T; 
  scanf("%d", &T);
  while (T--) {
    int xa, ya, xb, yb;
    scanf("%d%d%d%d%d", &k, &xa, &ya, &xb, &yb);
    --xa; --ya; --xb; --yb;
    printf("%d\n", solve(m, n, k, k, xa, ya, xb, yb));
  }

  return 0;
}
